<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.911624762 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A73" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA73INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA73ISB_SPEC + $BarrierOperationsPercentageCortexA73DSB_SPEC) + $BarrierOperationsPercentageCortexA73DMB_SPEC) / $BarrierOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA73INST_RETIRED &gt; 0), (($BranchMPKICortexA73BR_MIS_PRED / $BranchMPKICortexA73INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA73INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA73CPU_CYCLES / $CyclesPerInstructionCortexA73INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA73INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA73CRYPTO_SPEC / $CryptoOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA73INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA73DP_SPEC - $IntegerOperationsPercentageCortexA73DSB_SPEC) / $IntegerOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA73CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA73INST_RETIRED / $InstructionsPerCycleCortexA73CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA73L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA73L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA73L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA73INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA73L1D_CACHE_REFILL / $L1DCacheMPKICortexA73INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA73INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA73L1D_TLB_REFILL / $L1DataTLBMPKICortexA73INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA73L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA73L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA73L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA73INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA73L1I_CACHE_REFILL / $L1ICacheMPKICortexA73INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA73INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA73L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA73INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA73L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA73L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA73L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA73INST_RETIRED &gt; 0), (($L2CacheMPKICortexA73L2D_CACHE_REFILL / $L2CacheMPKICortexA73INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageCortexA73L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageCortexA73L2D_CACHE_REFILL / $L2DCacheMissPercentageCortexA73L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexA73INST_RETIRED &gt; 0), (($L2DCacheMPKICortexA73L2D_CACHE_REFILL / $L2DCacheMPKICortexA73INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexA73INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexA73LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexA73INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA73LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA73LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA73LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA73INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA73LD_SPEC / $LoadOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA73INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA73LDST_SPEC / $LoadStoreOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Instructions Percentage">
        <series color="19,148,180" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA73INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA73INST_RETIRED / $RetiredInstructionsPercentageCortexA73INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA73INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA73VFP_SPEC / $FloatingPointOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA73INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA73ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA73LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA73ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA73LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA73INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA73ST_SPEC / $StoreOperationsPercentageCortexA73INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKICortexA73INST_SPEC &gt; 0), (($StoreExclusiveFailuresPKICortexA73STREX_FAIL_SPEC / $StoreExclusiveFailuresPKICortexA73INST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
    <select-metric id="ARMv8_Cortex_A73_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A73_metric_cpi" />
    <select-metric id="ARMv8_Cortex_A73_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A73_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A73_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A73_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A73_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A73_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A73_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A73_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A73_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A73_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A73_metric_l2d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A73_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A73_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_A73_metric_strex_fail_mpki" />
</template>
